//Written by Paul Stothard, University of Alberta, Canada

function dnaPattern (theDocument) {	
	var newDna = "";
	var maxInput = 500000;
	var matches = new Array();

	if (testScript() == false) {
		return false;
	}

	if ((checkFormElement (theDocument.forms[0].elements[0]) == false) || (checkSequenceLength(theDocument.forms[0].elements[0].value, maxInput) == false) || (checkFormElement (theDocument.forms[0].elements[1]) == false))	{
		return false;
	}
	
	var re = "/" + theDocument.forms[0].elements[1].value.replace(/\//g,"") + "/gi";

	try {
		re = eval(re);
		var testString = "teststring";
		testString = testString.replace(re, "");
	}
	catch(e) {
		alert ("The regular expression is not formatted correctly.");
		return false;
	}

	openWindow("DNA Pattern Find");
	openPre();
	var arrayOfFasta = getArrayOfFasta (theDocument.forms[0].elements[0].value);


	for (var i = 0; i < arrayOfFasta.length; i++)	{
		
		newDna = getSequenceFromFasta (arrayOfFasta[i]);
		title = getTitleFromFasta (arrayOfFasta[i]);
		newDna = removeNonDna(newDna);
	
		outputWindow.document.write(getInfoFromTitleAndSequence(title, newDna));

		writeDnaPattern(newDna, re);

		outputWindow.document.write ('\n\n');
	}
	
	closePre();
	closeWindow();
	return true;
}

function writeDnaPattern (dnaSequence, re)	{
	var matchArray;
	var matchPosition;
	var matchFound = false;
	var matchCount = 1;
	var re2 = re;
	var simplePattern = re.toString();
	simplePattern = simplePattern.replace(/\/gi$|\/ig$|^\//gi, "");
	while (matchArray = re.exec(dnaSequence)) {
		matchPosition = re.lastIndex;
		outputWindow.document.write ("&gt;match number " + matchCount + " to \"" + simplePattern + "\" ends at position " + matchPosition + " on the direct strand\n" + addReturns(matchArray[0]) + "\n\n");
		matchFound = true;
		matchCount++;				
	}

	//now search the reverse-complement
	dnaSequence = reverse(complement(dnaSequence));
	while (matchArray = re2.exec(dnaSequence)) {
		matchPosition = re2.lastIndex;
		outputWindow.document.write ("&gt;match number " + matchCount + " to \"" + simplePattern + "\" ends at position " + matchPosition + " on the reverse strand\n" + addReturns(matchArray[0]) + "\n\n");
		matchFound = true;
		matchCount++;				
	}		

	if (!(matchFound)) {
		outputWindow.document.write ("no matches found for this sequence.\n\n");
	}
}

