//Written by Paul Stothard, University of Alberta, Canada

function dnaStats (theDocument) {	

	var newDna = "";
	var title = "";
	var maxInput = 500000;

	if (testScript() == false) {
		return false;
	}

	if ((checkFormElement (theDocument.forms[0].elements[0]) == false) || (checkSequenceLength(theDocument.forms[0].elements[0].value, maxInput) == false))	{
		return false;
	}
	
	var itemsToCheck = ["/g/ (g)1", "/a/ (a)1", "/t/ (t)1", "/c/ (c)1", "/n/ (n)1", "/u/ (u)1", "/r/ (r)1", "/y/ (y)1", "/s/ (s)1", "/w/ (w)1", "/k/ (k)1", "/m/ (m)1", "/b/ (b)1", "/d/ (d)1", "/h/ (h)1", "/v/ (v)1", "/gg/ (gg)2", "/ga/ (ga)2", "/gt/ (gt)2", "/gc/ (gc)2", "/gn/ (gn)2", "/ag/ (ag)2", "/aa/ (aa)2", "/at/ (at)2", "/ac/ (ac)2", "/an/ (an)2", "/tg/ (tg)2", "/ta/ (ta)2", "/tt/ (tt)2", "/tc/ (tc)2", "/tn/ (tn)2", "/cg/ (cg)2", "/ca/ (ca)2", "/ct/ (ct)2", "/cc/ (cc)2", "/cn/ (cn)2", "/ng/ (ng)2", "/na/ (na)2", "/nt/ (nt)2", "/nc/ (nc)2", "/nn/ (nn)2", "/g|c/ (g,c)1", "/a|t/ (a,t)1", "/r|y|s|w|k/ (r,y,s,w,k)1", "/b|h|d|v|n/ (b,h,d,v,n)1", "/r|y|s|w|k|m|b|d|h|v|n/ (r,y,s,w,k,m,b,d,h,v,n)1"];
	
	openWindow("DNA Stats");
	
	var arrayOfFasta = getArrayOfFasta (theDocument.forms[0].elements[0].value);

	for (var i = 0; i < arrayOfFasta.length; i++)	{
		newDna = getSequenceFromFasta (arrayOfFasta[i]);
		title = getTitleFromFasta (arrayOfFasta[i]);

		newDna = removeNonDna(newDna);

		outputWindow.document.write(getInfoFromTitleAndSequence(title, newDna));

		writeSequenceStats (newDna, itemsToCheck);

		outputWindow.document.write ('<br />\n<br />\n');
	}

	closeWindow();
	return true;
}



	
